local t = Def.ActorFrame{
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset transparent header", SCREEN_CENTER_X*0.5, SCREEN_CENTER_Y*0.6 );
	AutoText("frutiger",true) .. {
		Text="Gameplay User Preferences";
		InitCommand=cmd(x,WideScale(-88,-100);y,-79;z,5;draworder,100;horizalign,left;shadowlength,0;strokecolor,color("0,0,0,0");zoom,0.45;diffuse,color("0,0,0,1"));
	};
};

-- gameplay prefs 1
local displayMods = GetUserPrefB("DisplayModsOption");
local gameplayTitle = GetUserPrefB("GameplayTitle");
local dpMeter = GetUserPrefB("DPMeter");
local songBPM = GetUserPrefB("SongBPMDisplay");

local function GetTextColorForPref(pref)
	return pref and color("1,1,1,1") or color("1,1,1,0.5")
end;

local gameplaySection1 = Def.ActorFrame{
	InitCommand=cmd(y,-62);
	AutoText("frutiger") .. {
		Text="Mods";
		InitCommand=cmd(x,-36;shadowlength,0;strokecolor,color("0,0,0,0");zoom,0.75;diffuse,GetTextColorForPref(displayMods));
	};
	AutoText("frutiger") .. {
		Text="Title";
		InitCommand=cmd(x,36;shadowlength,0;strokecolor,color("0,0,0,0");zoom,0.75;diffuse,GetTextColorForPref(gameplayTitle));
	};
	AutoText("frutiger") .. {
		Text="DP Meter";
		InitCommand=cmd(x,-36;y,18;shadowlength,0;strokecolor,color("0,0,0,0");zoom,0.75;diffuse,GetTextColorForPref(dpMeter));
	};
	AutoText("frutiger") .. {
		Text="BPM";
		InitCommand=cmd(x,36;y,18;shadowlength,0;strokecolor,color("0,0,0,0");zoom,0.75;diffuse,GetTextColorForPref(songBPM));
	};
};
t[#t+1] = gameplaySection1;

-- Filter Color and Cover Position
local filterColorP1 = GetUserPrefC("FilterColorP1");
local filterColorP2 = GetUserPrefC("FilterColorP2");
local coverHeightP1 = GetUserPrefN("CoverPositionP1");
local coverHeightP2 = GetUserPrefN("CoverPositionP2");
local gameplaySection2 = Def.ActorFrame{
	InitCommand=cmd(y,-10);
	Def.Quad{
		InitCommand=cmd(zoomto,WideScale(168,192),40;diffuse,color("0.975,0.975,0.975,1");fadetop,0.25;fadebottom,0.5);
	};
	Def.Quad{
		Name="FilterP1";
		InitCommand=cmd(x,WideScale(-80,-92);horizalign,left;zoomto,WideScale(72,88),32;diffuse,filterColorP1);
	};
	AutoText("frutiger",true) .. {
		Text=string.format("P1 Cover: %i",coverHeightP1);
		InitCommand=cmd(x,WideScale(-76,-88);horizalign,left;shadowlength,1;strokecolor,color("0,0,0,0.375");zoom,0.5;diffuse,color("1,1,1,1"));
	};
	Def.Quad{
		Name="FilterP2";
		InitCommand=cmd(x,WideScale(80,92);horizalign,right;zoomto,WideScale(72,88),32;diffuse,filterColorP2);
	};
	AutoText("frutiger",true) .. {
		Text=string.format("P2 Cover: %i",coverHeightP2);
		InitCommand=cmd(x,WideScale(76,88);horizalign,right;shadowlength,1;strokecolor,color("0,0,0,0.375");zoom,0.5;diffuse,color("1,1,1,1"));
	};
};
t[#t+1] = gameplaySection2;

-- toasty
local toasty = GetUserPref("Toasty");
local toastySection = Def.ActorFrame{
	InitCommand=cmd(x,WideScale(-60,-72);y,48);
	AutoText("frutiger",true) .. {
		Text="Toasty";
		InitCommand=cmd(y,-26;shadowlength,0;strokecolor,color("0,0,0,0");zoom,0.525;);
	};
	LoadActor( THEME:GetPathG("ScreenToastyOptions Icon","Choice/_icon base"))..{
		InitCommand=cmd(glow,HSVA(192,0.25,1,0.75));
	};
	LoadActor( THEME:GetPathG("ScreenToastyOptions Icon","Choice/_icon "..toasty));
};
t[#t+1] = toastySection;

-- judgment stuffs
local judgeTilt = GetUserPrefB("TiltJudgments");
local judgeOffset = GetUserPref("JudgmentSet"); -- "Normal" or "Offset"
local judgeGraphic = (judgeOffset == "Offset") and "offset judgments" or "judgments";
local judgeState = (judgeOffset == "Offset") and 2 or 1;

local judgeTiltSection = Def.ActorFrame{
	InitCommand=cmd(x,WideScale(48,56);y,48);
	-- this could probably be done nicer but I don't care right now
	LoadActor( THEME:GetPathG("Player","judgment/"..HDActor(judgeGraphic)) )..{
		InitCommand=cmd(pause;setstate,judgeState;zoom,0.5);
		BeginCommand=function(self)
			-- todo: based on who pressed the button make it rotate differently, a la gameplay?
			self:rotationx(judgeTilt and -4.5 or 0);
			self:rotationy(0);
			self:rotationz(judgeTilt and -3 or 0);
		end;
	};
};
t[#t+1] = judgeTiltSection;

return t;